!function(mod){"object"==typeof exports&&"object"==typeof module?mod(require("../../lib/codemirror")):"function"==typeof define&&define.amd?define(["../../lib/codemirror"],mod):mod(CodeMirror)}(function(CodeMirror){"use strict";function regexpFlags(regexp){var flags=regexp.flags;return null!=flags?flags:(regexp.ignoreCase?"i":"")+(regexp.global?"g":"")+(regexp.multiline?"m":"")}function ensureGlobal(regexp){return regexp.global?regexp:new RegExp(regexp.source,regexpFlags(regexp)+"g")}function maybeMultiline(regexp){return/\\s|\\n|\n|\\W|\\D|\[\^/.test(regexp.source)}function searchRegexpForward(doc,regexp,start){regexp=ensureGlobal(regexp);for(var line=start.line,ch=start.ch,last=doc.lastLine();line<=last;line++,ch=0){regexp.lastIndex=ch;var string=doc.getLine(line),match=regexp.exec(string);if(match)return{from:Pos(line,match.index),to:Pos(line,match.index+match[0].length),match:match}}}function searchRegexpForwardMultiline(doc,regexp,start){if(!maybeMultiline(regexp))return searchRegexpForward(doc,regexp,start);regexp=ensureGlobal(regexp);for(var string,chunk=1,line=start.line,last=doc.lastLine();line<=last;){for(var i=0;i<chunk;i++){var curLine=doc.getLine(line++);string=null==string?curLine:string+"\n"+curLine}chunk*=2,regexp.lastIndex=start.ch;var match=regexp.exec(string);if(match){var before=string.slice(0,match.index).split("\n"),inside=match[0].split("\n"),startLine=start.line+before.length-1,startCh=before[before.length-1].length;return{from:Pos(startLine,startCh),to:Pos(startLine+inside.length-1,1==inside.length?startCh+inside[0].length:inside[inside.length-1].length),match:match}}}}function lastMatchIn(string,regexp){for(var match,cutOff=0;;){regexp.lastIndex=cutOff;var newMatch=regexp.exec(string);if(!newMatch)return match;if((cutOff=(match=newMatch).index+(match[0].length||1))==string.length)return match}}function searchRegexpBackward(doc,regexp,start){regexp=ensureGlobal(regexp);for(var line=start.line,ch=start.ch,first=doc.firstLine();line>=first;line--,ch=-1){var string=doc.getLine(line);ch>-1&&(string=string.slice(0,ch));var match=lastMatchIn(string,regexp);if(match)return{from:Pos(line,match.index),to:Pos(line,match.index+match[0].length),match:match}}}function searchRegexpBackwardMultiline(doc,regexp,start){regexp=ensureGlobal(regexp);for(var string,chunk=1,line=start.line,first=doc.firstLine();line>=first;){for(var i=0;i<chunk;i++){var curLine=doc.getLine(line--);string=null==string?curLine.slice(0,start.ch):curLine+"\n"+string}chunk*=2;var match=lastMatchIn(string,regexp);if(match){var before=string.slice(0,match.index).split("\n"),inside=match[0].split("\n"),startLine=line+before.length,startCh=before[before.length-1].length;return{from:Pos(startLine,startCh),to:Pos(startLine+inside.length-1,1==inside.length?startCh+inside[0].length:inside[inside.length-1].length),match:match}}}}function adjustPos(orig,folded,pos,foldFunc){if(orig.length==folded.length)return pos;for(var min=0,max=pos+Math.max(0,orig.length-folded.length);;){if(min==max)return min;var mid=min+max>>1,len=foldFunc(orig.slice(0,mid)).length;if(len==pos)return mid;len>pos?max=mid:min=mid+1}}function searchStringForward(doc,query,start,caseFold){if(!query.length)return null;var fold=caseFold?doFold:noFold,lines=fold(query).split(/\r|\n\r?/);search:for(var line=start.line,ch=start.ch,last=doc.lastLine()+1-lines.length;line<=last;line++,ch=0){var orig=doc.getLine(line).slice(ch),string=fold(orig);if(1==lines.length){var found=string.indexOf(lines[0]);if(-1==found)continue search;start=adjustPos(orig,string,found,fold)+ch;return{from:Pos(line,adjustPos(orig,string,found,fold)+ch),to:Pos(line,adjustPos(orig,string,found+lines[0].length,fold)+ch)}}var cutFrom=string.length-lines[0].length;if(string.slice(cutFrom)==lines[0]){for(var i=1;i<lines.length-1;i++)if(fold(doc.getLine(line+i))!=lines[i])continue search;var end=doc.getLine(line+lines.length-1),endString=fold(end),lastLine=lines[lines.length-1];if(end.slice(0,lastLine.length)==lastLine)return{from:Pos(line,adjustPos(orig,string,cutFrom,fold)+ch),to:Pos(line+lines.length-1,adjustPos(end,endString,lastLine.length,fold))}}}}function searchStringBackward(doc,query,start,caseFold){if(!query.length)return null;var fold=caseFold?doFold:noFold,lines=fold(query).split(/\r|\n\r?/);search:for(var line=start.line,ch=start.ch,first=doc.firstLine()-1+lines.length;line>=first;line--,ch=-1){var orig=doc.getLine(line);ch>-1&&(orig=orig.slice(0,ch));var string=fold(orig);if(1==lines.length){var found=string.lastIndexOf(lines[0]);if(-1==found)continue search;return{from:Pos(line,adjustPos(orig,string,found,fold)),to:Pos(line,adjustPos(orig,string,found+lines[0].length,fold))}}var lastLine=lines[lines.length-1];if(string.slice(0,lastLine.length)==lastLine){var i=1;for(start=line-lines.length+1;i<lines.length-1;i++)if(fold(doc.getLine(start+i))!=lines[i])continue search;var top=doc.getLine(line+1-lines.length),topString=fold(top);if(topString.slice(topString.length-lines[0].length)==lines[0])return{from:Pos(line+1-lines.length,adjustPos(top,topString,top.length-lines[0].length,fold)),to:Pos(line,adjustPos(orig,string,lastLine.length,fold))}}}}function SearchCursor(doc,query,pos,options){var caseFold;this.atOccurrence=!1,this.doc=doc,pos=pos?doc.clipPos(pos):Pos(0,0),this.pos={from:pos,to:pos},"object"==typeof options?caseFold=options.caseFold:(caseFold=options,options=null),"string"==typeof query?(null==caseFold&&(caseFold=!1),this.matches=function(reverse,pos){return(reverse?searchStringBackward:searchStringForward)(doc,query,pos,caseFold)}):(query=ensureGlobal(query),options&&!1===options.multiline?this.matches=function(reverse,pos){return(reverse?searchRegexpBackward:searchRegexpForward)(doc,query,pos)}:this.matches=function(reverse,pos){return(reverse?searchRegexpBackwardMultiline:searchRegexpForwardMultiline)(doc,query,pos)})}var doFold,noFold,Pos=CodeMirror.Pos;String.prototype.normalize?(doFold=function(str){return str.normalize("NFD").toLowerCase()},noFold=function(str){return str.normalize("NFD")}):(doFold=function(str){return str.toLowerCase()},noFold=function(str){return str}),SearchCursor.prototype={findNext:function(){return this.find(!1)},findPrevious:function(){return this.find(!0)},find:function(reverse){for(var result=this.matches(reverse,this.doc.clipPos(reverse?this.pos.from:this.pos.to));result&&0==CodeMirror.cmpPos(result.from,result.to);)reverse?result.from.ch?result.from=Pos(result.from.line,result.from.ch-1):result=result.from.line==this.doc.firstLine()?null:this.matches(reverse,this.doc.clipPos(Pos(result.from.line-1))):result.to.ch<this.doc.getLine(result.to.line).length?result.to=Pos(result.to.line,result.to.ch+1):result=result.to.line==this.doc.lastLine()?null:this.matches(reverse,Pos(result.to.line+1,0));if(result)return this.pos=result,this.atOccurrence=!0,this.pos.match||!0;var end=Pos(reverse?this.doc.firstLine():this.doc.lastLine()+1,0);return this.pos={from:end,to:end},this.atOccurrence=!1},from:function(){if(this.atOccurrence)return this.pos.from},to:function(){if(this.atOccurrence)return this.pos.to},replace:function(newText,origin){if(this.atOccurrence){var lines=CodeMirror.splitLines(newText);this.doc.replaceRange(lines,this.pos.from,this.pos.to,origin),this.pos.to=Pos(this.pos.from.line+lines.length-1,lines[lines.length-1].length+(1==lines.length?this.pos.from.ch:0))}}},CodeMirror.defineExtension("getSearchCursor",function(query,pos,caseFold){return new SearchCursor(this.doc,query,pos,caseFold)}),CodeMirror.defineDocExtension("getSearchCursor",function(query,pos,caseFold){return new SearchCursor(this,query,pos,caseFold)}),CodeMirror.defineExtension("selectMatches",function(query,caseFold){for(var ranges=[],cur=this.getSearchCursor(query,this.getCursor("from"),caseFold);cur.findNext()&&!(CodeMirror.cmpPos(cur.to(),this.getCursor("to"))>0);)ranges.push({anchor:cur.from(),head:cur.to()});ranges.length&&this.setSelections(ranges,0)})});